/* 
   Qtechknow Creator Kit: Circuit 2: Button with LED
 
   Demonstrates the use of a button and an LED. If button
   is pressed, the LED turns on, if not the LED is off
   
   Button is at D6, and LED is at D13
 
   created by Qtechknow
   made on 8 July 15
   
 */
 
#include "Qduino.h"
#include "Wire.h"

qduino q;  // initialize the library

int ledPin = 13;  // let's use blue (RGB LED)
int buttonPin = 6;  // attach button to D6

void setup() {
  
  q.setup();
  
  pinMode(ledPin, OUTPUT);
  pinMode(buttonPin, INPUT_PULLUP);
  
}

void loop() {
  
  int buttonState = digitalRead(buttonPin);
  
  if(buttonState == HIGH) {  // if button is pushed,
    
    digitalWrite(ledPin, HIGH);  // turn LED on
    
  } else {
    
    digitalWrite(ledPin, LOW); // if not, turn LED off
    
  }
}


